 
IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[UFD_RC_DEB_VL_JUR]') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [DBO].[UFD_RC_DEB_VL_JUR]
GO
 
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--SELECT DBO.UFD_RC_DEB_VL_JUR(1,900,271) 
CREATE FUNCTION [DBO].[UFD_RC_DEB_VL_JUR]    (@CD_EMP			INT, 
											  @CD_FILIAL		INT, 
											  @CD_RC_DEB		INT) 
RETURNS MONEY AS 
	
BEGIN

	DECLARE @VL_JUR MONEY
	DECLARE @DATA_HOJE DATETIME

	DECLARE @RS_PGTO TABLE (CD_EMP			INT,
							CD_FILIAL		INT,
							CD_RC_DEB		INT,
							SLD_DP			MONEY,
							DT_NV_VENCTO  	DATETIME,
							PERC_MULTA		MONEY,
							PERC_JUROS  	MONEY,
							DT_PAG			DATETIME)

	SET @DATA_HOJE = CONVERT(VARCHAR(10),GETDATE(),101)

	IF EXISTS(SELECT 1 FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CALCULA_JUROS_A_PARTIR_DO_ULTIMO_PAGAMENTO' and VALOR = '0')
	BEGIN

		INSERT INTO @RS_PGTO 
		SELECT 
			RC_DEB.CD_EMP,
			RC_DEB.CD_FILIAL,
			RC_DEB.CD_RC_DEB,
			RC_DEB.SLD_DP,	
			(CASE WHEN RC_DEB.DT_PRORROG IS NULL THEN 
				(CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
					(CASE WHEN DATEDIFF (DAY, RC_DEB.DT_VENCTO, @DATA_HOJE) >  MDL_CONV.DIAS_CAREN_ATRASO  THEN -- A QUANTIDADE DE DIAS DE ATRAZO SEJA SUPERIOR A QTDE DIAS CARENCIA ENT?O
						DATEADD(DAY, MDL_CONV.DIAS_CAREN_ATRASO, RC_DEB.DT_VENCTO)
					END)
				ELSE
					(CASE WHEN DATEDIFF (DAY, RC_DEB.DT_VENCTO, @DATA_HOJE) >  MDL.DIAS_CAREN_ATRASO  THEN -- A QUANTIDADE DE DIAS DE ATRAZO SEJA SUPERIOR A QTDE DIAS CARENCIA ENT?O
						DATEADD(DAY, MDL.DIAS_CAREN_ATRASO, RC_DEB.DT_VENCTO)
					END)		
				END)		 	
			ELSE 
				RC_DEB.DT_PRORROG 
			END) AS DT_NV_VENCTO,
		
			--ISNULL(MDL.PERC_JUROS_MULTA,0) AS PERC_MULTA,
			--ISNULL(MDL.PERC_JUROS_ATRASO,0) AS PERC_JUROS,

			CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
				ISNULL(MDL_CONV.PERC_JUROS_MULTA,0) 
			ELSE		
				ISNULL(MDL.PERC_JUROS_MULTA,0) 
			END AS PERC_MULTA,

			CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
				ISNULL(MDL_CONV.PERC_JUROS_ATRASO,0) 
			ELSE		
				ISNULL(MDL.PERC_JUROS_ATRASO,0) 
			END AS PERC_JUROS,

			MAX(CASE WHEN RC_CRED.VL_PGTO > 0 THEN RC_CRED.DT_PAG ELSE NULL END) AS DT_PAG

		FROM RC_DEB LEFT JOIN RC_CRED ON
			RC_DEB.CD_EMP = RC_CRED.CD_EMP	
			AND RC_DEB.CD_FILIAL = RC_CRED.CD_FILIAL
			AND RC_DEB.CD_RC_DEB= RC_CRED.CD_RC_DEB 


			LEFT JOIN RC_CLI_CREDIARIO CRED ON 
			RC_DEB.CD_EMP=CRED.CD_EMP AND
			RC_DEB.CD_CLI=CRED.CD_CLI 
			
			LEFT JOIN RC_MDL_VENDA MDL ON
			CRED.CD_EMP=MDL.CD_EMP AND 
			CRED.CD_MDL_VD=MDL.CD_MDL_VD 

			LEFT OUTER JOIN RC_DEB_RC_CLI_CONV ON
			RC_DEB_RC_CLI_CONV.CD_EMP=RC_DEB.CD_EMP AND
			RC_DEB_RC_CLI_CONV.CD_FILIAL=RC_DEB.CD_FILIAL AND
			RC_DEB_RC_CLI_CONV.CD_RC_DEB=RC_DEB.CD_RC_DEB

			LEFT JOIN RC_CLI_CONV CONV ON
			CONV.CD_EMP=RC_DEB_RC_CLI_CONV.CD_EMP AND
			CONV.CD_CONV=RC_DEB_RC_CLI_CONV.CD_CONV 

			LEFT JOIN RC_MDL_VENDA MDL_CONV ON
			MDL_CONV.CD_EMP=CONV.CD_EMP AND
			MDL_CONV.CD_MDL_VD=CONV.CD_MDL_VD

		WHERE 
			RC_DEB.CD_EMP = @CD_EMP
			AND RC_DEB.CD_FILIAL = @CD_FILIAL 
			AND RC_DEB.CD_RC_DEB = @CD_RC_DEB
			AND RC_DEB.SLD_DP > 0
		GROUP BY 
			RC_DEB.CD_EMP,
			RC_DEB.CD_FILIAL,
			RC_DEB.CD_RC_DEB,
			RC_DEB.SLD_DP,
			RC_DEB.DT_PRORROG,
			RC_DEB.DT_VENCTO,
			RC_DEB.PERC_MULTA,
			RC_DEB.PERC_JUROS,
			RC_DEB.CD_CLI,
			MDL.DIAS_CAREN_ATRASO,
			MDL.PERC_JUROS_MULTA,
			MDL.PERC_JUROS_ATRASO,
			CRED.CD_MDL_VD
			,MDL_CONV.PERC_JUROS_MULTA,
			MDL_CONV.PERC_JUROS_ATRASO
			,RC_DEB_RC_CLI_CONV.CD_RC_DEB
			,MDL_CONV.DIAS_CAREN_ATRASO
					 
		SET @VL_JUR =ISNULL( (SELECT
								   (CASE WHEN CONVERT(VARCHAR(10), GETDATE(), 101) > DT_NV_VENCTO THEN
										--Alterado para buscar a data do ultimo pagamento, para calcular juros somente do que no foi pago.
										ROUND(((SLD_DP * PERC_MULTA) / 100), 2) 
										+ ROUND(((SLD_DP * ((PERC_JUROS / 30) * DATEDIFF(DAY, DT_NV_VENCTO, CONVERT(VARCHAR(10), GETDATE(), 101)))) / 100), 2)
									END) AS VL_JUR
								FROM @RS_PGTO RS_PGTO) ,0)

	END
	ELSE
	BEGIN
		INSERT INTO @RS_PGTO 
		SELECT 
			RC_DEB.CD_EMP,
			RC_DEB.CD_FILIAL,
			RC_DEB.CD_RC_DEB,
			RC_DEB.SLD_DP,	
			(CASE WHEN RC_DEB.DT_PRORROG IS NULL THEN 
				(CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
					(CASE WHEN DATEDIFF (DAY, RC_DEB.DT_VENCTO, @DATA_HOJE) >  MDL_CONV.DIAS_CAREN_ATRASO  THEN -- A QUANTIDADE DE DIAS DE ATRAZO SEJA SUPERIOR A QTDE DIAS CARENCIA ENT?O
						RC_DEB.DT_VENCTO 
					ELSE
						DATEADD(DAY, MDL_CONV.DIAS_CAREN_ATRASO, RC_DEB.DT_VENCTO)
					END)
				ELSE
					(CASE WHEN DATEDIFF (DAY, RC_DEB.DT_VENCTO, @DATA_HOJE) >  MDL.DIAS_CAREN_ATRASO  THEN -- A QUANTIDADE DE DIAS DE ATRAZO SEJA SUPERIOR A QTDE DIAS CARENCIA ENT?O
						RC_DEB.DT_VENCTO 
					ELSE
						DATEADD(DAY, MDL.DIAS_CAREN_ATRASO, RC_DEB.DT_VENCTO)
					END)		
				END)		 	
			ELSE 
				RC_DEB.DT_PRORROG 
			END) AS DT_NV_VENCTO,
			
			--ISNULL(MDL.PERC_JUROS_MULTA,0) AS PERC_MULTA,
			--ISNULL(MDL.PERC_JUROS_ATRASO,0) AS PERC_JUROS,

			CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
				ISNULL(MDL_CONV.PERC_JUROS_MULTA,0) 
			ELSE		
				ISNULL(MDL.PERC_JUROS_MULTA,0) 
			END AS PERC_MULTA,

			CASE WHEN ISNULL(RC_DEB_RC_CLI_CONV.CD_RC_DEB,0) > 0 THEN
				ISNULL(MDL_CONV.PERC_JUROS_ATRASO,0) 
			ELSE		
				ISNULL(MDL.PERC_JUROS_ATRASO,0) 
			END AS PERC_JUROS,

			MAX(CASE WHEN RC_CRED.VL_PGTO > 0 THEN RC_CRED.DT_PAG ELSE NULL END) AS DT_PAG

		FROM RC_DEB LEFT JOIN RC_CRED ON
			RC_DEB.CD_EMP = RC_CRED.CD_EMP	
			AND RC_DEB.CD_FILIAL = RC_CRED.CD_FILIAL
			AND RC_DEB.CD_RC_DEB= RC_CRED.CD_RC_DEB 


			LEFT JOIN RC_CLI_CREDIARIO CRED ON 
			RC_DEB.CD_EMP=CRED.CD_EMP AND
			RC_DEB.CD_CLI=CRED.CD_CLI 
			
			LEFT JOIN RC_MDL_VENDA MDL ON
			CRED.CD_EMP=MDL.CD_EMP AND 
			CRED.CD_MDL_VD=MDL.CD_MDL_VD 

			LEFT OUTER JOIN RC_DEB_RC_CLI_CONV ON
			RC_DEB_RC_CLI_CONV.CD_EMP=RC_DEB.CD_EMP AND
			RC_DEB_RC_CLI_CONV.CD_FILIAL=RC_DEB.CD_FILIAL AND
			RC_DEB_RC_CLI_CONV.CD_RC_DEB=RC_DEB.CD_RC_DEB

			LEFT JOIN RC_CLI_CONV CONV ON
			CONV.CD_EMP=RC_DEB_RC_CLI_CONV.CD_EMP AND
			CONV.CD_CONV=RC_DEB_RC_CLI_CONV.CD_CONV 

			LEFT JOIN RC_MDL_VENDA MDL_CONV ON
			MDL_CONV.CD_EMP=CONV.CD_EMP AND
			MDL_CONV.CD_MDL_VD=CONV.CD_MDL_VD

		WHERE 
			RC_DEB.CD_EMP = @CD_EMP
			AND RC_DEB.CD_FILIAL = @CD_FILIAL 
			AND RC_DEB.CD_RC_DEB = @CD_RC_DEB
			AND RC_DEB.SLD_DP > 0
		GROUP BY 
			RC_DEB.CD_EMP,
			RC_DEB.CD_FILIAL,
			RC_DEB.CD_RC_DEB,
			RC_DEB.SLD_DP,
			RC_DEB.DT_PRORROG,
			RC_DEB.DT_VENCTO,
			RC_DEB.PERC_MULTA,
			RC_DEB.PERC_JUROS,
			RC_DEB.CD_CLI,
			MDL.DIAS_CAREN_ATRASO,
			MDL.PERC_JUROS_MULTA,
			MDL.PERC_JUROS_ATRASO,
			CRED.CD_MDL_VD
			,MDL_CONV.PERC_JUROS_MULTA,
			MDL_CONV.PERC_JUROS_ATRASO
			,RC_DEB_RC_CLI_CONV.CD_RC_DEB
			,MDL_CONV.DIAS_CAREN_ATRASO
					 
		SET @VL_JUR =(SELECT 
			(CASE WHEN DT_PAG IS NULL THEN 
				CASE WHEN CONVERT(VARCHAR(10),GETDATE(),101) > DT_NV_VENCTO THEN
					ROUND(((SLD_DP * PERC_MULTA) / 100),2) + 
					ROUND(((SLD_DP * ((PERC_JUROS / 30) * DATEDIFF(DAY, DT_NV_VENCTO, CONVERT(VARCHAR(10),GETDATE(),101)))) / 100),2) 
					- 
					ROUND(ISNULL((SELECT SUM(VL_JUR) FROM RC_CRED WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_RC_DEB = @CD_RC_DEB),0),2)			
				ELSE
					0
				END
			 ELSE
			 
				CASE WHEN DT_PAG < DT_NV_VENCTO THEN     ----    < 18
					CASE WHEN CONVERT(VARCHAR(10),GETDATE(),101) > DT_NV_VENCTO THEN
						ROUND(((SLD_DP * ((PERC_JUROS / 30) * DATEDIFF(DAY, DT_NV_VENCTO, CONVERT(VARCHAR(10),GETDATE(),101)))) / 100),2) -
						ROUND(ISNULL((SELECT SUM(VL_JUR) FROM RC_CRED WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_RC_DEB = @CD_RC_DEB AND DT_PAG > RS_PGTO.DT_PAG),0),2)
					ELSE
						0
					END
										
				ELSE
					CASE WHEN CONVERT(VARCHAR(10),GETDATE(),101) > DT_PAG THEN
						----ALTERADO PARA BUSCAR A DATA DO ULTIMO PAGAMENTO, PARA CALCULAR JUROS SOMENTE DO QUE NO FOI PAGO.
						ROUND(((SLD_DP * PERC_MULTA) / 100),2) + 					
						ROUND(((SLD_DP * ((PERC_JUROS / 30) * DATEDIFF(DAY, DT_PAG, CONVERT(VARCHAR(10),GETDATE(),101)))) / 100),2) -
						ROUND(ISNULL((SELECT SUM(VL_JUR) FROM RC_CRED WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_RC_DEB = @CD_RC_DEB AND DT_PAG > RS_PGTO.DT_PAG),0),2)
					ELSE
						0
					END
				END		
			 END)	AS VL_JUR
		FROM @RS_PGTO RS_PGTO)
	END
	RETURN @VL_JUR
END	
	


GO

